unit MainFrm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, SUPasswords, SURules, SUGeneral;

type
  TForm1 = class(TForm)
    edPassword: TEdit;
    lblPass: TLabel;
    bbVerify: TButton;
    GroupBox1: TGroupBox;
    cbUpper: TCheckBox;
    cbLower: TCheckBox;
    cbDigits: TCheckBox;
    cbQwerty: TCheckBox;
    cbRepeatSeq: TCheckBox;
    procedure bbVerifyClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.bbVerifyClick(Sender: TObject);
var
  Pass: TSUPassword;
  Rules: TSUPasswordRulesList;
begin
  Pass := TSUPassword.Create(edPassword.Text);
  Rules := TSUPasswordRulesList.Create;
  try
    if cbUpper.Checked then
      Rules.Add(TSUUppercaseCharacterRule.Create);
    if cbLower.Checked then
      Rules.Add(TSULowercaseCharacterRule.Create);
    if cbDigits.Checked then
      Rules.Add(TSUDigitsRule.Create);
    if cbQwerty.Checked then
      Rules.Add(TSUQwertySequenceRule.Create);
    if cbRepeatSeq.Checked then
      Rules.Add(TSURepeatCharacterRule.Create);

    if Pass.Validate(Rules) then
      ShowMessage('Validated successfully!')
    else
      ShowMessage('Does not match rules!');
  finally
    FreeAndNil(Rules); // frees added rules automatically
    FreeAndNil(Pass);
  end;
end;

end.
